
from PIL import ImageDraw, Image, ImageFont
import time
from epd_2inch9 import *
from image import *
from epd_gui import *
import gpiozero

'''define pin conection in wiringpi number
2.9inch_EPD    Raspberry Pi
      VCC   --->   3.3V
      GND   --->   GND
      RST   --->   P0
      BUSY  --->   P5
      D/C   --->   P6
      MOSI  --->   MOSI
      CLK   --->   CLK
      CS    --->   (CE0)P10 
'''
'''
screen coordinates gor gui functions
-----------------> x (0~168)
|
|
|
|
y(0~384)
'''
if __name__ == '__main__':
    gui = EPD_GUI()
    gui.epd.hw_init()
    gui.epd.PIC_display(gImage_1)  # Refresh the picture in full screen
    gui.epd.sleep()  # EPD_sleep,Sleep instruction is necessary, please do not delete!!!
    time.sleep(4)  # delay 4s

    gui.epd.hw_init()
    gui.epd.whitescreen_yellow() 
    gui.epd.sleep()  # EPD_sleep,Sleep instruction is necessary, please do not delete!!!
    time.sleep(2)  # delay 2s
    
    gui.epd.hw_init()
    gui.epd.whitescreen_red() 
    gui.epd.sleep()  # EPD_sleep,Sleep instruction is necessary, please do not delete!!!
    time.sleep(2)  # delay 2s
    
    gui.epd.hw_init()  # EPD init
    gui.clear(EPD_2IN9G_WHITE)

    font_16 = ImageFont.truetype("MiSans-Light.ttf", FONT_SIZE_16)  # read chinese font file
    font_20 = ImageFont.truetype("MiSans-Light.ttf", FONT_SIZE_20)  # read chinese font file
    font_24 = ImageFont.truetype("MiSans-Light.ttf", FONT_SIZE_24)  # read chinese font file
    font_28 = ImageFont.truetype("MiSans-Light.ttf", FONT_SIZE_28)  # read chinese font file
    # Point
    gui.draw_point(3, 1, EPD_2IN9G_BLACK, PIXEL_1X1, DOT_STYLE_DFT)
    gui.draw_point(3, 15, EPD_2IN9G_YELLOW, PIXEL_2X2, DOT_STYLE_DFT)
    gui.draw_point(5, 40, EPD_2IN9G_BLACK, PIXEL_3X3, DOT_STYLE_DFT)
    gui.draw_point(5, 55, EPD_2IN9G_RED, PIXEL_4X4, DOT_STYLE_DFT)
    # Line
    gui.draw_line(15, 10, 55, 50, EPD_2IN9G_BLACK, PIXEL_1X1, LINE_SOLID)
    gui.draw_line(55, 10, 15, 50, EPD_2IN9G_BLACK, PIXEL_1X1, LINE_SOLID)
    # Rectangle
    gui.draw_rectangle(15, 5, 55, 45, EPD_2IN9G_BLACK, FILL_EMPTY, PIXEL_1X1)
    gui.draw_rectangle(90, 5, 130, 45, EPD_2IN9G_BLACK, FILL_FULL, PIXEL_1X1)
    # Circle
    gui.draw_circle(170, 25, 18, EPD_2IN9G_YELLOW, FILL_EMPTY, PIXEL_1X1)
    gui.draw_circle(226, 25, 18, EPD_2IN9G_RED, FILL_FULL, PIXEL_1X1)
    gui.draw_str(60, 50, "168x384", EPD_2IN9G_YELLOW, FONT_SIZE_16, font_16)
    gui.draw_str(140, 50, "SPI interface", EPD_2IN9G_RED, FONT_SIZE_20, font_20)
    gui.draw_str(80, 75, "2.9\" E-Paper", EPD_2IN9G_YELLOW, FONT_SIZE_24, font_24)
    gui.draw_str(70, 100, "SEENGREAT", EPD_2IN9G_RED, FONT_SIZE_28, font_28)
    # TEST_PIN = 1
    gui.epd.GUI_display(gui.img)  # display image need 2.08s
    time.sleep(4)  # 4s
    gui.epd.sleep()  # EPD_DeepSleep, Sleep instruction is necessary, please do not delete!!!


    # Clear screen
    gui.epd.hw_init()  # EPD init  initialization
    gui.epd.whitescreen_white()  # Show all white
    gui.epd.sleep()  # Enter deep sleep, Sleep instruction is necessary, please do not delete!!!
    time.sleep(2)
    print("end")
    exit(1)

